IF  EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='EST_MOVIMENTO_VENDAS_PRODUTOS_ANT')
BEGIN
	drop table EST_MOVIMENTO_VENDAS_PRODUTOS_ANT;
end
GO
IF NOT EXISTS (SELECT * FROM SYS.COLUMNS WHERE NAME = 'VLR_ISSQN' AND OBJECT_ID = OBJECT_ID('EST_MOVIMENTO_VENDAS_PRODUTOS'))
begin
	exec SP_RENAME 'EST_MOVIMENTO_VENDAS_PRODUTOS', 'EST_MOVIMENTO_VENDAS_PRODUTOS_ANT';
	exec SP_RENAME 'PK_EST_MOVIMENTO_VENDAS_PRODUTOS', 'PK_EST_MOVIMENTO_VENDAS_PRODUTOS_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_EMP', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_EMP_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_VD', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_VD_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_ITENS', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_ITENS_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_VD_LIQ', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_VD_LIQ_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_PMC', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_PMC_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO_MD', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO_MD_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO_GER', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO_GER_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_OFERTA', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_OFERTA_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_VERBA', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_VERBA_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_RATEIO', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_RATEIO_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_ICMS', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_ICMS_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_PIS_COFINS', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_PIS_COFINS_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_QTDE_ITENS', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_QTDE_ITENS_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DINHEIRO', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DINHEIRO_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUES', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUES_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUES_VISTA', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUES_VISTA_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUES_PRAZO', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUES_PRAZO_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CARTAO', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CARTAO_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_TICKETS', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_TICKETS_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DUPLICATA', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DUPLICATA_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CONV', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CONV_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUE_TROCO', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUE_TROCO_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_NCC', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_NCC_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_VEND', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_VEND_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_OPERADOR', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_OPERADOR_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_QTDE_VD', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_QTDE_VD_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_COMISSAO', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_COMISSAO_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_COMISSAO_FABRIC', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_COMISSAO_FABRIC_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_RECOMPOSICAO_MARGEM', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_RECOMPOSICAO_MARGEM_ANT';
	exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_PROD', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_PROD_ANT';

	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'DF_Table_1_CD_ARV_MERC_CATEG_1') AND type in (N'D'))
	begin
		exec SP_RENAME 'DF_Table_1_CD_ARV_MERC_CATEG_1', 'DF_Table_1_CD_ARV_MERC_CATEG_1_ANT';
	end
	
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CONV_PBM') AND type in (N'D'))
	begin
			exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CONV_PBM', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CONV_PBM_ANT';
	end

	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_ORIGEM_VENDA') AND type in (N'D'))
	begin
			exec SP_RENAME 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_ORIGEM_VENDA', 'DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_ORIGEM_VENDA_ANT';
	end
	
	exec SP_RENAME 'FK_EST_MOVIMENTO_VENDAS_PRODUTOS_EST_MOVIMENTO_VENDAS', 'FK_EST_MOVIMENTO_VENDAS_PRODUTOS_EST_MOVIMENTO_VENDAS_ANT';
	
	print 'CRIANDO A NOVA ESTRUTURA DA TABELA'
	CREATE TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS](
		[CD_CTR_VENDAS] [int] NOT NULL,
		[CD_EMP] [int] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[VLR_VD] [money] NOT NULL,
		[VLR_DESC_ITENS] [money] NOT NULL,
		[VLR_VD_LIQ] [money] NOT NULL,
		[VLR_PMC] [money] NOT NULL,
		[VLR_CUSTO_MD] [money] NOT NULL,
		[VLR_CUSTO_GER] [money] NOT NULL,
		[VLR_CUSTO] [money] NOT NULL,
		[VLR_DESC_OFERTA] [money] NOT NULL,
		[VLR_DESC_VERBA] [money] NOT NULL,
		[VLR_DESC_RATEIO] [money] NOT NULL,
		[VLR_ICMS] [money] NOT NULL,
		[VLR_PIS_COFINS] [money] NOT NULL,
		[QTDE_ITENS] [money] NOT NULL,
		[VLR_DINHEIRO] [money] NULL,
		[VLR_CHEQUES] [money] NULL,
		[VLR_CHEQUES_VISTA] [money] NULL,
		[VLR_CHEQUES_PRAZO] [money] NULL,
		[VLR_CARTAO] [money] NULL,
		[VLR_TICKETS] [money] NULL,
		[VLR_DUPLICATA] [money] NULL,
		[VLR_CONV] [money] NULL,
		[VLR_CHEQUE_TROCO] [money] NULL,
		[VLR_NCC] [money] NULL,
		[CD_VEND] [int] NOT NULL,
		[CD_OPERADOR] [int] NOT NULL,
		[QTDE_VD] [money] NULL,
		[VLR_COMISSAO] [money] NULL,
		[VLR_COMISSAO_FABRIC] [money] NULL,
		[VLR_RECOMPOSICAO_MARGEM] [money] NULL,
		[VLR_CONV_PBM] [money] NULL,
		[CD_ORIGEM_VENDA] [int] NOT NULL,
		[VLR_ISSQN] [MONEY] NOT NULL,
	 CONSTRAINT [PK_EST_MOVIMENTO_VENDAS_PRODUTOS] PRIMARY KEY CLUSTERED 
	(
		[CD_CTR_VENDAS] ASC,
		[CD_EMP] ASC,
		[CD_PROD] ASC,
		[CD_VEND] ASC,
		[CD_OPERADOR] ASC,
		[CD_ORIGEM_VENDA] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_VD]  DEFAULT ((0)) FOR [VLR_VD]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_ITENS]  DEFAULT ((0)) FOR [VLR_DESC_ITENS]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_VD_LIQ]  DEFAULT ((0)) FOR [VLR_VD_LIQ]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_PMC]  DEFAULT ((0)) FOR [VLR_PMC]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO_MD]  DEFAULT ((0)) FOR [VLR_CUSTO_MD]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO_GER]  DEFAULT ((0)) FOR [VLR_CUSTO_GER]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO]  DEFAULT ((0)) FOR [VLR_CUSTO]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_OFERTA]  DEFAULT ((0)) FOR [VLR_DESC_OFERTA]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_VERBA]  DEFAULT ((0)) FOR [VLR_DESC_VERBA]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_RATEIO]  DEFAULT ((0)) FOR [VLR_DESC_RATEIO]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_ICMS]  DEFAULT ((0)) FOR [VLR_ICMS]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_PIS_COFINS]  DEFAULT ((0)) FOR [VLR_PIS_COFINS]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_QTDE_ITENS]  DEFAULT ((0)) FOR [QTDE_ITENS]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DINHEIRO]  DEFAULT ((0)) FOR [VLR_DINHEIRO]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUES]  DEFAULT ((0)) FOR [VLR_CHEQUES]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUES_VISTA]  DEFAULT ((0)) FOR [VLR_CHEQUES_VISTA]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUES_PRAZO]  DEFAULT ((0)) FOR [VLR_CHEQUES_PRAZO]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CARTAO]  DEFAULT ((0)) FOR [VLR_CARTAO]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_TICKETS]  DEFAULT ((0)) FOR [VLR_TICKETS]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DUPLICATA]  DEFAULT ((0)) FOR [VLR_DUPLICATA]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CONV]  DEFAULT ((0)) FOR [VLR_CONV]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CHEQUE_TROCO]  DEFAULT ((0)) FOR [VLR_CHEQUE_TROCO]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_NCC]  DEFAULT ((0)) FOR [VLR_NCC]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_VEND]  DEFAULT ((0)) FOR [CD_VEND]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_OPERADOR]  DEFAULT ((0)) FOR [CD_OPERADOR]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_QTDE_VD]  DEFAULT ((0)) FOR [QTDE_VD]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_COMISSAO]  DEFAULT ((0)) FOR [VLR_COMISSAO]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_COMISSAO_FABRIC]  DEFAULT ((0)) FOR [VLR_COMISSAO_FABRIC]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_RECOMPOSICAO_MARGEM]  DEFAULT ((0)) FOR [VLR_RECOMPOSICAO_MARGEM]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CONV_PBM]  DEFAULT ((0)) FOR [VLR_CONV_PBM]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_ORIGEM_VENDA]  DEFAULT ((0)) FOR [CD_ORIGEM_VENDA]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_ISSQN]  DEFAULT ((0)) FOR [VLR_ISSQN]

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS]  WITH CHECK ADD  CONSTRAINT [FK_EST_MOVIMENTO_VENDAS_PRODUTOS_EST_MOVIMENTO_VENDAS] FOREIGN KEY([CD_CTR_VENDAS])
	REFERENCES [dbo].[EST_MOVIMENTO_VENDAS] ([CD_CTR_VENDAS])
	ON UPDATE CASCADE
	ON DELETE CASCADE

	ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] CHECK CONSTRAINT [FK_EST_MOVIMENTO_VENDAS_PRODUTOS_EST_MOVIMENTO_VENDAS]
	
	print 'INSERINDO DADOS ANTERIORES'

	INSERT INTO EST_MOVIMENTO_VENDAS_PRODUTOS
	(	CD_CTR_VENDAS,
		CD_EMP,
		CD_PROD,
		VLR_VD,
		VLR_DESC_ITENS,
		VLR_VD_LIQ,
		VLR_PMC,
		VLR_CUSTO_MD,
		VLR_CUSTO_GER,
		VLR_CUSTO,
		VLR_DESC_OFERTA,
		VLR_DESC_VERBA,
		VLR_DESC_RATEIO,
		VLR_ICMS,
		VLR_PIS_COFINS,
		QTDE_ITENS,
		VLR_DINHEIRO,
		VLR_CHEQUES,
		VLR_CHEQUES_VISTA,
		VLR_CHEQUES_PRAZO,
		VLR_CARTAO,
		VLR_TICKETS,
		VLR_DUPLICATA,
		VLR_CONV,
		VLR_CHEQUE_TROCO,
		VLR_NCC,
		CD_VEND,
		CD_OPERADOR,
		QTDE_VD,
		VLR_COMISSAO,
		VLR_COMISSAO_FABRIC,
		VLR_RECOMPOSICAO_MARGEM,
		VLR_CONV_PBM,
		CD_ORIGEM_VENDA,
		VLR_ISSQN
	)
	SELECT
		CD_CTR_VENDAS,
		CD_EMP,
		CD_PROD,
		VLR_VD,
		VLR_DESC_ITENS,
		VLR_VD_LIQ,
		VLR_PMC,
		VLR_CUSTO_MD,
		VLR_CUSTO_GER,
		VLR_CUSTO,
		VLR_DESC_OFERTA,
		VLR_DESC_VERBA,
		VLR_DESC_RATEIO,
		VLR_ICMS,
		VLR_PIS_COFINS,
		QTDE_ITENS,
		VLR_DINHEIRO,
		VLR_CHEQUES,
		VLR_CHEQUES_VISTA,
		VLR_CHEQUES_PRAZO,
		VLR_CARTAO,
		VLR_TICKETS,
		VLR_DUPLICATA,
		VLR_CONV,
		VLR_CHEQUE_TROCO,
		VLR_NCC,
		CD_VEND,
		CD_OPERADOR,
		QTDE_VD,
		VLR_COMISSAO,
		VLR_COMISSAO_FABRIC,
		0 AS VLR_RECOMPOSICAO_MARGEM,
		0 AS VLR_CONV_PBM,
		0 AS CD_ORIGEM_VENDA,
		0 AS VLR_ISSQN
	FROM
		EST_MOVIMENTO_VENDAS_PRODUTOS_ANT;
END
GO
print 'DELETANDO DADOS ANTIGOS'

IF  EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='EST_MOVIMENTO_VENDAS_PRODUTOS_ANT')
BEGIN
	drop table EST_MOVIMENTO_VENDAS_PRODUTOS_ANT;
end